document.addEventListener("DOMContentLoaded", function(){
  // show domainbookmark list
  var slideToggle = document.querySelector('.dropdown_toggle');
  let bookmarkName = document.getElementById('bookmark_name');
  let btnSave = document.querySelector(".btn_save");
  btnSave.disabled = true;
  // slideToggle.addEventListener('click', openMenu);
  // function openMenu(){
  //   document.querySelector('.dropdown_menu').classList.toggle('open_menu');

  //   // hide alert
  //   if (successNotif.classList.contains('hide') == false){
  //     toggleAlert(successNotif);
  //   }
  //   else if (failedNotif.classList.contains('hide') == false){
  //     toggleAlert(failedNotif);
  //   }
  // }

  document.body.addEventListener('click', ()=>{
    // Hide visible alerts
    if (successNotif.classList.contains('hide') == false){
      toggleAlert(successNotif);
    }
    else if (failedNotif.classList.contains('hide') == false){
      toggleAlert(failedNotif);
    }

    // Disable save btn
    if(document.querySelector('.dropdown_menu li input:checked') !== null){
      btnSave.disabled = false;
    }else{
      btnSave.disabled = true;
    }
  }, true); 

  // btnSave.disabled = true;
  // bookmarkName.addEventListener('keyup', stateHandle);
  // function stateHandle() {
  //   if (document.getElementById('bookmark_name').value === "") {
  //     btnSave.disabled = true;
  //   } else {
  //     btnSave.disabled = false;
  //   }
  //   document.getElementById('bookmark_name').value = document.getElementById('bookmark_name').value.toLowerCase();
  // }

  // Set shortname value
  chrome.tabs.query({active: true, lastFocusedWindow: true}, tabs => {
    let val = tabs[0].url;
    bookmarkName.value = getHostName(val);
  });

  function getHostName(url) {
    var match = url.match(/:\/\/(www[0-9]?\.)?(.[^/:]+)/i);
    if (match != null && match.length > 2 && typeof match[2] === 'string' && match[2].length > 0) {
      var hostname = match[2].split(".");
      return hostname[0];
    }
    else {
      return null;
    }
  }

  // Restrict space and special characters
  document.querySelector('#bookmark_name').addEventListener('input', function() {
    var c = this.selectionStart,
      r = /[^a-zA-Z0-9-]/gi,
      v = $(this).val();
    if(r.test(v)) {
      $(this).val(v.replace(r, ''));
      c--;
    }
    this.setSelectionRange(c, c);
  });

  document.querySelector('#logout').addEventListener("click", function(){
    chrome.runtime.sendMessage({message:'logout'}, function(response){
      if(response === 'loggedout') send_login();
    });
  });

  function send_login(){
    window.location.href="validation.html"
  }

  var domain_ids = []
  //Loads domain and bookmark
  $('.domain_body').hide()
  $('.dir-loader-container').show()
  chrome.runtime.sendMessage({message:'loaddomains'}, function(response){
    if(response.message === 'success') {
      adddomainrows(response.body, domain_ids);
      domain_ids.forEach(function(ids) {
        chrome.runtime.sendMessage({message:'loadbookmarks', payload: ids}, function(response){
          if(response.message === 'success'){
            addbookmark(response.body);
            $('.dir-loader-container').hide()
            $('.domain_body').show()
            listAddShowClass(ids)
          } 
        });
      });
      listAddShowClass()
    }else{
      //This means that the token expired. If so logout/clear the user token
      document.querySelector('#logout').click()
    }
  });

  function adddomainrows(domains, domain_ids){
    if(domains.length == 0){
      $('.dir-loader-container').hide()
      $('.empty-dir').show()
    }else{
      Object.entries(domains).forEach(([k,v]) => {
        document.getElementById('row-body').insertAdjacentHTML('beforeend',`<div>
        <li class="li-dom" id="lidomain-` +v['id'] + `">
          <div class="li-info">
            <a href="#" class="dropdown-directory"><i class="icn icn-dropdown"></i></a>
            <i class="icn icn-dom"></i>
            <input type="radio" id="domain-` +v['id'] + `" name="radio-group" value="`+v['name']+ `" data-domain_id = "`+ v['id'] + `" data-bookmark_id = null>
            <label for="domain-`+v['id']+`">`+v['name']+ `</label>
          </div>
          <ul class="subcontainer">
  
          </ul>
        </li> 
        </div>`)
        domain_ids.push(v['id'])
      })
    }
  }

  function addbookmark(bookmark){
    let id ="";
    Object.entries(bookmark).forEach(([k,v]) => {
      id = document.getElementById(`lidomain-${v['domain_id']}`);
      ename = v['subdomain']+'.'+$('#domain-'+v['domain_id']).val()
      if(v['ancestry'] === null){
        id.getElementsByTagName('ul')[0].insertAdjacentHTML('beforeend',`
        <li class="li-subd" id="libookmark-`+ v['id'] + `">
          <div class="li-info">
            <a href="#" class="dropdown-directory"><i class="icn icn-dropdown"></i></a>
            <i class="icn icn-subd"></i>
            <input type="radio" id="bookmark-`+ v['id'] + `" name="radio-group" value="`+v['subdomain']+`" data-domain_id = "`+ v['domain_id'] + `" data-bookmark_id = "`+ v['id'] + `">
            <label for="bookmark-`+ v['id'] + `">`+ename+`</label>
          </div>
        </li>`);
      }else{
        ancestor = v['ancestry'].split('/').pop() //gets last element of ancestry
        $('#libookmark-'+ancestor).append(`<ul class="subcontainer">
        <li class="li-subd" id="libookmark-`+ v['id'] + `">
          <div class="li-info">
            <a href="#" class="dropdown-directory"><i class="icn icn-dropdown"></i></a>
            <i class="icn icn-subd"></i>
            <input type="radio" id="bookmark-`+ v['id'] + `" name="radio-group" value="`+v['subdomain']+`" data-domain_id = "`+ v['domain_id'] + `" data-bookmark_id = "`+ v['id'] + `">
            <label for="bookmark-`+ v['id'] + `">`+ename+`</label>
          </div>
        </li>`);
      }
    })
    //document.querySelectorAll('.dropdown_menu li input').forEach(function(item){
    //  item.onclick = function(e){
    //    slideToggle.innerHTML = this.value;
    //    slideToggle.dataset.domain_id = this.dataset.domain_id
    //    slideToggle.dataset.bookmark_id = this.dataset.bookmark_id
    //  }
    //});
  }
  
  

  //Create bookmark
  document.querySelector('form').addEventListener('submit', event=>{
    event.preventDefault();

    //Get current page URL
    chrome.tabs.query({active: true, lastFocusedWindow: true}, tabs => {
      let content = tabs[0].url;
      let subdomain = document.getElementById('bookmark_name').value
      let domain_id = getRadioValue('radio-group').dataset.domain_id
      let parent_id = getRadioValue('radio-group').dataset.bookmark_id
      let bookmarkable_subdomain = getRadioValue('tab-input')
      let cont = {}

      if(parent_id != 'null'){
        cont ={content, subdomain, parent_id, bookmarkable_subdomain, domain_id }
      }else{
        if(bookmarkable_subdomain === "true"){
          cont ={subdomain, bookmarkable_subdomain, domain_id }
        }else{
          cont ={content, subdomain, bookmarkable_subdomain, domain_id }
        }
      }

      if(domain_id && subdomain && urlChecker(tabs[0].url)){
        // btnSave.disabled = true;
        btnSave.innerHTML = '<img src="assets/img/blue-spinner.gif" style="display: inline-block; width: 15px; margin-right: 8px;">';
          chrome.runtime.sendMessage({message:'createbookmark', dom_id: domain_id, payload: cont }, function(response){
              if(response.status === 'success'){
                //Upon successful boomark creation
                showAlertClearForm(successNotif, '');
              }else if (response.status === 'fail'){
                showAlertClearForm(failedNotif, humanize(response.errors[0]));
              }
          });
      }else{
        showAlertClearForm(failedNotif, 'URL is not valid');
      }
    });
  })

  // Alert
  const successNotif = document.querySelector('.alert_success');
  const successNotifMessage = successNotif.innerHTML
  const failedNotif = document.querySelector('.alert_failed');
  const failNotifMessage = failedNotif.innerHTML

  function showAlertClearForm(alerttype, showMessage){
    // bookmarkName.value =''
    // slideToggle.innerHTML = 'Select directory'
    // bookmarkTab.checked = true;
    // slideToggle.click();
    btnSave.innerHTML = "SAVE";
    if(showMessage != ''){
      alerttype.innerHTML = showMessage
    }else{
      if(alerttype == successNotif){
        bookmarkName.value =''
        alerttype.innerHTML = successNotifMessage
      }else{
        alerttype.innerHTML = failNotifMessage
      }
    }
    toggleAlert(alerttype);
    uncheckedMenu();
  }

  function clearForm(){
    bookmarkName.value ='';
    // hide menu
    // if(document.querySelector('.dropdown_menu').classList.contains('open_menu') == true){
    //   slideToggle.click();
    // }
    // hide alert
    if (successNotif.classList.contains('hide') == false){
      toggleAlert(successNotif);
    }
    else if (failedNotif.classList.contains('hide') == false){
      toggleAlert(failedNotif);
    }
    // unselect from menu
    uncheckedMenu();
  }

  function uncheckedMenu(){
    try {
      document.querySelector('.dropdown_menu li input:checked').checked = false; 
      btnSave.disabled = true;
    } catch (error) {
      return false;
    }
  }

  function toggleAlert(alerttype){
    if (alerttype.classList.contains('hide')) {
      alerttype.classList.remove('hide');
      setTimeout(function () {
        alerttype.classList.remove('visually_hidden');
      }, 20);
    } else {
      alerttype.classList.add('visually_hidden');    
      alerttype.addEventListener('transitionend', function(e) {
        alerttype.classList.add('hide');
      }, {
        capture: false,
        once: true,
        passive: false
      });
    }
  }

  // Temporarily Hide - Add Bookmark or Directory TAB
  const bookmarkTab = document.getElementById('add-bm-btn');
  const directoryTab = document.getElementById('add-dir-btn');
  const labelType = document.getElementsByClassName('label-type');
  
  // bookmarkTab.addEventListener("click", function(){

  //   Array.prototype.forEach.call(labelType, function(e){
  //     e.innerHTML = 'bookmark';
  //   });
  //   slideToggle.innerHTML = 'Select directory'
  //   clearForm();
  // });

  // directoryTab.addEventListener("click", function(){
    
  //   Array.prototype.forEach.call(labelType, function(e){
  //     e.innerHTML = 'directory';
  //   });
  //   slideToggle.innerHTML = 'Select domain'
  //   clearForm();
  // });

  function getRadioValue(theRadioGroup){
    var elements = document.getElementsByName(theRadioGroup);
    for (var i = 0, l = elements.length; i < l; i++)
    {
        if (elements[i].checked)
        {
            return elements[i];
        }
    }
  }

  function urlChecker(urlString){
    var urlPattern = new RegExp('^(https?:\\/\\/)+');
    return !!urlPattern.test(urlString);
  }

  function humanize(str) {
    str = str.replace(/\s{2,}/g, ' ');
    arr = str.split(' and ')
    str = uniq(arr).join(" and ")
    str = str.toLowerCase()
    return str
        .replace(/^[\s_]+|[\s_]+$/g, '')
        .replace(/[_\s]+/g, ' ')
        .replace(/^[a-z]/, function(m) { return m.toUpperCase(); });
  }
  
  function uniq(a){
    var seen = {};
    return a.filter(function(item) {
        return seen.hasOwnProperty(item) ? false : (seen[item] = true);
    });
  }
});
